 const previewBtn = document.getElementById("previewBtn");
const image = document.getElementById("previewImage");
const fileInput = document.getElementById("fileInput");

/* Toggle blur */
previewBtn.addEventListener("click", () => {
    image.classList.toggle("blur");
});

/* Show uploaded image */
fileInput.addEventListener("change", () => {
    const file = fileInput.files[0];

    if (!file) return;

    if (!file.type.startsWith("image/")) {
        alert("Please upload an image file");
        return;
    }

    const reader = new FileReader();
    reader.onload = () => {
        image.src = reader.result;
    };
    reader.readAsDataURL(file);
});
